(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     53040,       1305]
NotebookOptionsPosition[     52469,       1281]
NotebookOutlinePosition[     52823,       1297]
CellTagsIndexPosition[     52780,       1294]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.654768152281385*^9, 3.654768169552766*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"eye", " ", "guidance", " ", "line", " ", "y"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"-", "ax"}], " ", "+", " ", "b"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "=", " ", "1"}], ";", " ", 
    RowBox[{"b", " ", "=", " ", 
     RowBox[{"1", "/", "0.38"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "*", " ", "Nematic", " ", "transition", " ", "and", " ", "Chiral", " ", 
     "transition", " ", "data"}], " ", "**)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemI", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5.7"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "5.7"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemO", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "3"}]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemT", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.96"}], ",", " ", 
       RowBox[{"b", "-", " ", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "1.96"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemDinf", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.16"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "1.16"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemD2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.06"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "1.06"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemCinf", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.59"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.59"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemC2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.57"}], ",", " ", 
       RowBox[{"b", " ", "-", " ", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.57"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemC1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "/", "a"}], ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChiI", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.22"}], ",", " ", 
       RowBox[{"b", " ", "-", " ", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "5.9"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChiO", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.22"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "3"}]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChiT", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.22"}], ",", " ", 
       RowBox[{"b", " ", "-", " ", 
        RowBox[{"a", " ", "*", " ", 
         RowBox[{"1", "/", "1.96"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemCD", "=", 
     RowBox[{"{", 
      RowBox[{"NemC1", ",", "NemCinf", ",", "NemD2", ",", "NemDinf"}], 
      "}"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemTOI", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"NemT", ",", "NemO", ",", "NemI"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemCn", " ", "=", " ", 
     RowBox[{"{", "NemCinf", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemDn", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"NemD2", ",", "NemDinf"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChiData", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"ChiT", ",", " ", "ChiO", ",", "ChiI"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemIh", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5.9"}], ",", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "5.9"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemOh", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3.1"}], ",", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "3.1"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemTd", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2.22"}], ",", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "2.22"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemTh", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2.18"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "2.18"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemDinfh", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.32"}], ",", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "1.32"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemD2d", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.28"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "1.28"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemD2h", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "1.15"}], ",", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "1.15"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemCinfh", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.98"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.98"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemC2h", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.87"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.87"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemS2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.66"}], ",", 
       RowBox[{"b", " ", "-", " ", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.66"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemCinfv", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.62"}], ",", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.62"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemC2v", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.60"}], ",", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.60"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemC1v", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "0.47"}], ",", " ", 
       RowBox[{"b", "-", 
        RowBox[{"a", "*", 
         RowBox[{"1", "/", "0.47"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NemImproper", "=", 
     RowBox[{"{", 
      RowBox[{
      "NemIh", ",", "NemOh", ",", "NemTd", ",", "NemTh", ",", "NemDinfh", ",",
        "NemD2d", ",", "NemD2h", ",", "NemCinfh", ",", "NemC2h", ",", "NemS2",
        ",", "NemCinfv", ",", "NemC1v"}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6570225792517223`*^9, 3.6570227357851048`*^9}, {
   3.6570228208477488`*^9, 3.657022860921979*^9}, {3.6570229196691504`*^9, 
   3.657022945305936*^9}, {3.6570229771654797`*^9, 3.657023648724195*^9}, {
   3.657023690372696*^9, 3.6570237704863863`*^9}, {3.65702380069631*^9, 
   3.65702386349679*^9}, {3.657024092698678*^9, 3.657024342281005*^9}, {
   3.657024401375654*^9, 3.6570244445555563`*^9}, {3.657024487296191*^9, 
   3.657024521531138*^9}, {3.6570246277140903`*^9, 3.657024956685521*^9}, {
   3.65702513839965*^9, 3.657025144174361*^9}, {3.6570252050101633`*^9, 
   3.657025225601982*^9}, {3.6570252935900497`*^9, 3.657025371509207*^9}, {
   3.6570254019778757`*^9, 3.6570254446546793`*^9}, {3.657025511624*^9, 
   3.657025650200234*^9}, {3.657025711112504*^9, 3.657025721215061*^9}, {
   3.657025754512871*^9, 3.6570257999781713`*^9}, {3.657025882387087*^9, 
   3.6570258969796963`*^9}, {3.657025940251851*^9, 3.657025976205481*^9}, {
   3.657026032990118*^9, 3.657026068548541*^9}, {3.657026523715238*^9, 
   3.657026639553214*^9}, {3.657026691895063*^9, 3.657026695001718*^9}, {
   3.657026808976301*^9, 3.6570268696595783`*^9}, {3.6570269058559313`*^9, 
   3.65702691489038*^9}, {3.657026949337682*^9, 3.657027180249848*^9}, {
   3.6570272908557577`*^9, 3.657027322946451*^9}, {3.657027369959115*^9, 
   3.657027417112961*^9}, {3.657027509161705*^9, 3.657027559706277*^9}, {
   3.657027627068857*^9, 3.65702766240596*^9}, {3.657027789047988*^9, 
   3.657027789186881*^9}, {3.657027830942889*^9, 3.657027831698921*^9}, {
   3.657027871017077*^9, 3.657027995431658*^9}, {3.657028163891165*^9, 
   3.657028169575872*^9}, {3.6570282082634087`*^9, 3.657028302063609*^9}, {
   3.657028333816676*^9, 3.657028416748303*^9}, {3.657028453501356*^9, 
   3.657028463788289*^9}, {3.657028543795188*^9, 3.6570285444600563`*^9}, {
   3.6570285882671824`*^9, 3.657028611513809*^9}, {3.657028653524732*^9, 
   3.657028658157124*^9}, {3.657029992693651*^9, 3.657030034600483*^9}, {
   3.657030067041368*^9, 3.65703014861504*^9}, 3.657191075115519*^9, {
   3.657191113112315*^9, 3.6571911939929543`*^9}, {3.657191258257185*^9, 
   3.657191278582958*^9}, {3.6571914984884357`*^9, 3.657191566694518*^9}, {
   3.6571916723372*^9, 3.6571917039878817`*^9}, {3.6571917658112993`*^9, 
   3.6571917831336946`*^9}, {3.657191825504476*^9, 3.657191845505207*^9}, {
   3.657192081805264*^9, 3.6571920858673697`*^9}, {3.657192154648572*^9, 
   3.6571923518128443`*^9}, {3.65719238844799*^9, 3.6571924368788157`*^9}, {
   3.657192594856964*^9, 3.6571927016435547`*^9}, {3.657192862555935*^9, 
   3.657192867653481*^9}, {3.657192958287952*^9, 3.6571929989179707`*^9}, {
   3.657193094730897*^9, 3.6571931504852867`*^9}, {3.657193221722509*^9, 
   3.657193287860031*^9}, {3.657193367909679*^9, 3.657193429536248*^9}, {
   3.657193517583836*^9, 3.657193542574024*^9}, {3.657193578024332*^9, 
   3.657193869815164*^9}, {3.657193924544788*^9, 3.657193925139244*^9}, {
   3.657194025056082*^9, 3.65719404316564*^9}, {3.657194112913196*^9, 
   3.6571941133164186`*^9}, {3.658936073456566*^9, 3.658936215538292*^9}, {
   3.658936255104331*^9, 3.658936411262867*^9}, {3.658936456274075*^9, 
   3.6589364605393667`*^9}, {3.658936537427126*^9, 3.658936575778614*^9}, {
   3.658937181955612*^9, 3.6589372002192917`*^9}, {3.659292960064975*^9, 
   3.659293107723448*^9}, {3.6592931885263853`*^9, 3.6592932140586348`*^9}, {
   3.65929324706149*^9, 3.659293307312317*^9}, {3.6592933506139107`*^9, 
   3.6592933931196127`*^9}, {3.659293426666709*^9, 3.659293445436607*^9}, {
   3.659293485445589*^9, 3.6592935409988623`*^9}, {3.659293619379991*^9, 
   3.659293621882124*^9}, {3.6592942435710993`*^9, 3.6592942449955893`*^9}, {
   3.659297819298008*^9, 3.659297822910894*^9}, {3.659298084498114*^9, 
   3.6592980876175117`*^9}, {3.659380958785676*^9, 3.659380962209092*^9}, {
   3.664174586524691*^9, 3.664174619797717*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "ticks", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"LeftTicks", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "\"\<\!\(\*SubscriptBox[\(C\), \(1\)]\)\>\""}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.59"}]}]}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(\[Infinity]\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.06"}]}]}], ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.06"}]}], "-", "0.03"}], ",", "\"\<D2\>\"", 
         ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.16"}]}]}], ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.16"}]}], "+", "0.03"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(D\), \(\[Infinity]\)]\)\>\"", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.96"}]}]}], ",", "\"\<T\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "3"}]}]}], ",", "\"\<O\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "5.7"}]}]}], ",", "\"\<I \>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "\"\<SO(3)\>\""}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LeftTicks2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "\"\<\!\(\*SubscriptBox[\(C\), \(1\)]\)\>\"", ",", 
         "0.005"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.57"}]}]}], ",", "Null", ",", "0.005"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.59"}]}]}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(\[Infinity]\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.06"}]}]}], ",", "Null", ",", "0.005"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.06"}]}], "-", "0.05"}], ",", "\"\<D2\>\"", 
         ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.16"}]}]}], ",", "Null", ",", "0.005"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.16"}]}], "+", "0.05"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(D\), \(\[Infinity]\)]\)\>\"", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.96"}]}]}], ",", "\"\<T\>\"", ",", "0.005"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "3"}]}]}], ",", "\"\<O\>\"", ",", "0.005"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "5.7"}]}]}], ",", "\"\<I \>\"", ",", "0.005"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "\"\<SO(3)\>\""}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RightTicks", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.62"}]}]}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(\[Infinity]v\)]\)\>\""}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.98"}]}]}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(\[Infinity]h\)]\)\>\""}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.32"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(D\), \(\[Infinity]h\)]\)\>\""}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "2.18"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "2.22"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(d\)]\)\>\"", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "3.1"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(O\), \(h\)]\)\>\"", ",", "0.005"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "5.8"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(I\), \(h\)]\)\>\"", ",", "0.005"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "\"\<O(3)\>\""}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RightTicks2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.47"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(1  v\)]\)=\!\(\*SubscriptBox[\(C\), \
\(1  h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.62"}]}]}], ",", " ", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.62"}]}], "-", "0.01"}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(\[Infinity]v\)]\)\>\"", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.66"}]}]}], ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.66"}]}], "+", "0.01"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(S\), \(2\)]\)=\!\(\*SubscriptBox[\(C\), \
\(i\)]\)\>\"", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.87"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(2  h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.98"}]}]}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \
\(\[Infinity]h\)]\)=\!\(\*SubscriptBox[\(S\), \(\[Infinity]\)]\)\>\""}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.15"}]}], "-", "0.04"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(D\), \(2  h\)]\)\>\"", ",", "0"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.15"}]}]}], ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.28"}]}], "-", "0.02"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(D\), \(2  d\)]\)\>\"", ",", "0"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.28"}]}]}], ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.32"}]}]}], ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.32"}]}], "+", "0.06"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(D\), \
\(\[Infinity]h\)]\)=\!\(\*SubscriptBox[\(D\), \(\[Infinity]d\)]\)\>\"", ",", 
         "0"}], "}"}], ",", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "2.18"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(d\)]\),\!\(\*SubscriptBox[\(T\), \
\(h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "2.22"}]}]}], ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "3.1"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(O\), \(h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "5.9"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(I\), \(h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "\"\<O(3)\>\""}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RightTicks3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.62"}]}]}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(\[Infinity]v\)]\)\>\""}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "0.98"}]}]}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(C\), \(\[Infinity]h\)]\)\>\""}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "1.32"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(D\), \(\[Infinity]h\)]\)\>\""}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "2.18"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "2.22"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(d\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "3.1"}]}]}], ",", 
         "\"\<\!\(\*SubscriptBox[\(O\), \(h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "-", 
          RowBox[{"a", "*", 
           RowBox[{"1", "/", "5.8"}]}]}], ",", 
         "\"\< \!\(\*SubscriptBox[\(I\), \(h\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "\"\<O(3)\>\""}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BottomTicks", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9", ",", "2.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4", ",", "Null"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot1", " ", "=", " ", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"NemCD", ",", "ChiData", ",", "NemTOI"}], "}"}], ",", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\[FivePointedStar]", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[FilledSmallCircle]", ",", "14"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[FivePointedStar]", ",", "12"}], "}"}]}], "}"}]}], " ", 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Darker", "[", 
           RowBox[{"Black", ",", "0"}], "]"}], ",", 
          RowBox[{"Darker", "[", 
           RowBox[{"Red", ",", "0"}], "]"}], ",", 
          RowBox[{"Darker", "[", 
           RowBox[{"Black", ",", "0"}], "]"}]}], "}"}]}], " ", ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", 
        RowBox[{"GoldenRatio", "-", "1"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"b", "+", "0.1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "b"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"LeftTicks", ",", "RightTicks2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Prolog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Lighter", "[", 
           RowBox[{"Gray", ",", 
            RowBox[{"GoldenRatio", "-", "1"}]}], "]"}], ",", 
          RowBox[{"Rectangle", "[", 
           RowBox[{
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "]"}]}], "}"}]}], ",", 
       
       RowBox[{"PlotRangeClipping", "->", "False"}], ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "13"}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plot3", " ", "=", " ", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", "NemImproper", "}"}], ",", 
      RowBox[{"PlotMarkers", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{"\[FilledVerySmallSquare]", ",", "24"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Darker", "[", 
         RowBox[{"Blue", ",", "0"}], "]"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot2", " ", "=", " ", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"NemCn", ",", "NemDn"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Darker", "[", 
             RowBox[{"Purple", ",", "0.1"}], "]"}], ",", 
            RowBox[{"Thickness", "[", "0.008", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Darker", "[", 
             RowBox[{"Purple", ",", "0.1"}], "]"}], ",", 
            RowBox[{"Thickness", "[", "0.008", "]"}]}], "}"}]}], "}"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FillSO3", " ", "=", " ", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "1.22"}], ",", "b"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
       RowBox[{"FillingStyle", "\[Rule]", 
        RowBox[{"Darker", "[", 
         RowBox[{"Cyan", ",", "0"}], "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FillNematic", " ", "=", " ", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"b", "/", "a"}], ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
       RowBox[{"FillingStyle", "\[Rule]", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Purple", ",", "0.4"}], "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FillSO32", " ", "=", " ", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "1.22"}], ",", "b"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
       RowBox[{"FillingStyle", "\[Rule]", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Blue", ",", "0.3"}], "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FillNematic2", " ", "=", " ", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"b", "/", "a"}], ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
       RowBox[{"FillingStyle", "\[Rule]", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Blue", ",", "0.5"}], "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"PD", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "plot1", ",", "FillSO3", ",", "FillNematic", ",", "plot3", ",", 
        "plot1"}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Isotropic\\nLiquid\>\"", ",", 
             RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.72", ",", "0.65"}], "}"}], "]"}]}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Chiral\\nLiquid\>\"", ",", 
             RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.24", ",", "0.86"}], "}"}], "]"}]}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<(Chiral)\\nNematic\>\"", ",", 
             RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.24", ",", "0.4"}], "}"}], "]"}]}], "]"}]}], "}"}]}]}],
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"Rotate", "[", 
         RowBox[{"\"\<//\>\"", ",", "0"}], "]"}], ",", 
        RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}], ",", " ", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0.86", ",", "0"}], "}"}], "]"}]}], "]"}], 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.6570225792517223`*^9, 3.6570227357851048`*^9}, {
   3.6570228208477488`*^9, 3.657022860921979*^9}, {3.6570229196691504`*^9, 
   3.657022945305936*^9}, {3.6570229771654797`*^9, 3.657023648724195*^9}, {
   3.657023690372696*^9, 3.6570237704863863`*^9}, {3.65702380069631*^9, 
   3.65702386349679*^9}, {3.657024092698678*^9, 3.657024342281005*^9}, {
   3.657024401375654*^9, 3.6570244445555563`*^9}, {3.657024487296191*^9, 
   3.657024521531138*^9}, {3.6570246277140903`*^9, 3.657024956685521*^9}, {
   3.65702513839965*^9, 3.657025144174361*^9}, {3.6570252050101633`*^9, 
   3.657025225601982*^9}, {3.6570252935900497`*^9, 3.657025371509207*^9}, {
   3.6570254019778757`*^9, 3.6570254446546793`*^9}, {3.657025511624*^9, 
   3.657025650200234*^9}, {3.657025711112504*^9, 3.657025721215061*^9}, {
   3.657025754512871*^9, 3.6570257999781713`*^9}, {3.657025882387087*^9, 
   3.6570258969796963`*^9}, {3.657025940251851*^9, 3.657025976205481*^9}, {
   3.657026032990118*^9, 3.657026068548541*^9}, {3.657026523715238*^9, 
   3.657026639553214*^9}, {3.657026691895063*^9, 3.657026695001718*^9}, {
   3.657026808976301*^9, 3.6570268696595783`*^9}, {3.6570269058559313`*^9, 
   3.65702691489038*^9}, {3.657026949337682*^9, 3.657027180249848*^9}, {
   3.6570272908557577`*^9, 3.657027322946451*^9}, {3.657027369959115*^9, 
   3.657027417112961*^9}, {3.657027509161705*^9, 3.657027559706277*^9}, {
   3.657027627068857*^9, 3.65702766240596*^9}, {3.657027789047988*^9, 
   3.657027789186881*^9}, {3.657027830942889*^9, 3.657027831698921*^9}, {
   3.657027871017077*^9, 3.657027995431658*^9}, {3.657028163891165*^9, 
   3.657028169575872*^9}, {3.6570282082634087`*^9, 3.657028302063609*^9}, {
   3.657028333816676*^9, 3.657028416748303*^9}, {3.657028453501356*^9, 
   3.657028463788289*^9}, {3.657028543795188*^9, 3.6570285444600563`*^9}, {
   3.6570285882671824`*^9, 3.657028611513809*^9}, {3.657028653524732*^9, 
   3.657028658157124*^9}, {3.657029992693651*^9, 3.657030034600483*^9}, {
   3.657030067041368*^9, 3.65703014861504*^9}, 3.657191075115519*^9, {
   3.657191113112315*^9, 3.6571911939929543`*^9}, {3.657191258257185*^9, 
   3.657191278582958*^9}, {3.6571914984884357`*^9, 3.657191566694518*^9}, {
   3.6571916723372*^9, 3.6571917039878817`*^9}, {3.6571917658112993`*^9, 
   3.6571917831336946`*^9}, {3.657191825504476*^9, 3.657191845505207*^9}, {
   3.657192081805264*^9, 3.6571920858673697`*^9}, {3.657192154648572*^9, 
   3.6571923518128443`*^9}, {3.65719238844799*^9, 3.6571924368788157`*^9}, {
   3.657192594856964*^9, 3.6571927016435547`*^9}, {3.657192862555935*^9, 
   3.657192867653481*^9}, {3.657192958287952*^9, 3.6571929989179707`*^9}, {
   3.657193094730897*^9, 3.6571931504852867`*^9}, {3.657193221722509*^9, 
   3.657193287860031*^9}, {3.657193367909679*^9, 3.657193429536248*^9}, {
   3.657193517583836*^9, 3.657193542574024*^9}, {3.657193578024332*^9, 
   3.657193869815164*^9}, {3.657193924544788*^9, 3.657193925139244*^9}, {
   3.657194025056082*^9, 3.65719404316564*^9}, {3.657194112913196*^9, 
   3.6571941133164186`*^9}, {3.658936073456566*^9, 3.658936132828891*^9}, {
   3.658936502728181*^9, 3.658936512940337*^9}, {3.65893658730247*^9, 
   3.658936734432198*^9}, {3.658936779606921*^9, 3.658936792962098*^9}, {
   3.658936826555254*^9, 3.658936954610174*^9}, {3.658936989252684*^9, 
   3.658937103100094*^9}, {3.658937216370267*^9, 3.6589372167555447`*^9}, {
   3.658937271336501*^9, 3.658937281687265*^9}, {3.658937319667066*^9, 
   3.6589373597307673`*^9}, {3.658937397164173*^9, 3.658937589550823*^9}, {
   3.658937695033914*^9, 3.658937870413526*^9}, {3.658937903462809*^9, 
   3.658937967013047*^9}, {3.658938002983251*^9, 3.6589380055090237`*^9}, {
   3.658938062879877*^9, 3.658938331446727*^9}, {3.658938410700466*^9, 
   3.658938413618951*^9}, {3.658938454547019*^9, 3.658938511072611*^9}, {
   3.6589385662162437`*^9, 3.658938718934246*^9}, {3.658938796913987*^9, 
   3.658939037514965*^9}, {3.658939071437813*^9, 3.658939116998516*^9}, {
   3.658939300023652*^9, 3.658939301296857*^9}, {3.6589393500106564`*^9, 
   3.6589393829283123`*^9}, {3.658939414998653*^9, 3.65893951162114*^9}, {
   3.65893954655103*^9, 3.658939614305653*^9}, {3.6589396511363773`*^9, 
   3.658939677610569*^9}, {3.658939715489012*^9, 3.658939811446642*^9}, {
   3.658939843265497*^9, 3.658939852185746*^9}, {3.658939906718981*^9, 
   3.6589399762939367`*^9}, {3.658940025534155*^9, 3.658940026083952*^9}, {
   3.658940110481913*^9, 3.658940110786284*^9}, {3.658940212175645*^9, 
   3.658940231305229*^9}, {3.658940320287518*^9, 3.6589403402440643`*^9}, {
   3.658940371483102*^9, 3.658940462144889*^9}, {3.658940510241281*^9, 
   3.658940629778071*^9}, {3.658943107675914*^9, 3.658943108683837*^9}, {
   3.658943247376272*^9, 3.658943250697802*^9}, 3.6592935757647943`*^9, {
   3.659293702715233*^9, 3.659293740415744*^9}, {3.659293849150648*^9, 
   3.659293870629381*^9}, {3.659293902612105*^9, 3.659294127859598*^9}, {
   3.659294159173373*^9, 3.659294190508935*^9}, {3.659294323067255*^9, 
   3.659294368151922*^9}, {3.6592944445242567`*^9, 3.659294522234055*^9}, {
   3.6592945878497467`*^9, 3.659294600730226*^9}, {3.659294644124056*^9, 
   3.65929468829867*^9}, {3.6592947336035748`*^9, 3.659294733732774*^9}, {
   3.659294774928439*^9, 3.659294834361002*^9}, {3.659294876202477*^9, 
   3.659294912271576*^9}, {3.659294970938551*^9, 3.659295003740671*^9}, {
   3.659295041789516*^9, 3.659295073116282*^9}, {3.659295318804469*^9, 
   3.659295386008387*^9}, {3.659295436367285*^9, 3.659295494090486*^9}, {
   3.659295542418416*^9, 3.6592955427492456`*^9}, {3.6592956101511583`*^9, 
   3.659295696146734*^9}, {3.659295758772025*^9, 3.6592957791874933`*^9}, {
   3.659295824680703*^9, 3.659295827751787*^9}, {3.659295870502697*^9, 
   3.659295949277337*^9}, {3.659295996799204*^9, 3.659296082695722*^9}, {
   3.659296114585177*^9, 3.6592961265917892`*^9}, {3.659296207812702*^9, 
   3.659296291662273*^9}, {3.659297841470945*^9, 3.65929784195829*^9}, {
   3.659297873449999*^9, 3.659297979166359*^9}, {3.6592980209852*^9, 
   3.659298076030751*^9}, {3.659298134508142*^9, 3.659298205699486*^9}, {
   3.6592982434534817`*^9, 3.65929835017002*^9}, {3.659380850782075*^9, 
   3.659380922885993*^9}, {3.659380991125156*^9, 3.659380991483508*^9}, {
   3.6596315016979513`*^9, 3.659631560333186*^9}, {3.6596316199703617`*^9, 
   3.65963176733605*^9}, {3.659631817242827*^9, 3.659632005854657*^9}, {
   3.659633484329556*^9, 3.659633575126128*^9}, {3.659633606156494*^9, 
   3.659633788410364*^9}, {3.664174635795355*^9, 3.664174724215453*^9}, {
   3.664174773988936*^9, 3.664174796658518*^9}, {3.664174914074421*^9, 
   3.664174914799075*^9}, {3.664174967886717*^9, 3.664174975926487*^9}, {
   3.664175122700378*^9, 3.664175193968649*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {
     {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledVerySmallSquare]",
         StripOnInput->False,
         FontSize->24], {0., 0.}], {{{0.1694915254237288, 
       2.4620874219446924`}}, {{0.3225806451612903, 2.3089983022071308`}}, {{
       0.4504504504504504, 2.181128496917971}}, {{0.4587155963302752, 
       2.172863351038146}}, {{0.7575757575757576, 1.8740031897926637`}}, {{
       0.78125, 1.8503289473684212`}}, {{0.8695652173913044, 
       1.7620137299771168`}}, {{1.0204081632653061`, 1.611170784103115}}, {{
       1.1494252873563218`, 1.4821536600120995`}}, {{1.5151515151515151`, 
       1.116427432216906}}, {{1.6129032258064517`, 1.0186757215619695`}}, {{
       2.127659574468085, 0.5039193729003362}}}]}, {}}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{False, False}, {False, False}},
   FrameLabel->{{None, None}, {None, None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   Method->{},
   PlotRange->{{0, 2.127659574468085}, {0, 2.4620874219446924`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.659298410759905*^9, 3.6592984197995043`*^9}, {
   3.659380867010385*^9, 3.659380923397707*^9}, 3.659380992177032*^9, 
   3.659631466947184*^9, {3.659631507293027*^9, 3.659631560822093*^9}, {
   3.659631623339645*^9, 3.6596317678919973`*^9}, {3.659631818330598*^9, 
   3.6596320067442513`*^9}, {3.659633489864273*^9, 3.659633506569255*^9}, {
   3.659633565012574*^9, 3.659633575740561*^9}, {3.659633607396689*^9, 
   3.659633732215632*^9}, 3.659633788721982*^9, 3.664174661566391*^9, 
   3.664174724765683*^9, 3.664174797239399*^9, 3.66417491915666*^9, {
   3.6641749771658297`*^9, 3.6641749897648373`*^9}, 3.66417519463745*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{{}, {
      {RGBColor[0, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         StyleBox["\[FivePointedStar]",
          StripOnInput->False,
          FontSize->12], {0., 0.}], {{{2.6315789473684212`, 0.}}, {{
        1.6949152542372883`, 0.936663693131133}}, {{0.9433962264150942, 
        1.688182720953327}}, {{0.8620689655172414, 1.7695099818511797`}}}]}, 
      {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         StyleBox["\[FilledSmallCircle]",
          StripOnInput->False,
          FontSize->14], {0., 0.}], {{{0.819672131147541, 
        2.1213748657357683`}}, {{0.819672131147541, 2.2982456140350878`}}, {{
        0.819672131147541, 2.4620874219446924`}}}]}, 
      {RGBColor[0, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         StyleBox["\[FivePointedStar]",
          StripOnInput->False,
          FontSize->12], {0., 0.}], {{{0.5102040816326531, 
        2.1213748657357683`}}, {{0.3333333333333333, 2.2982456140350878`}}, {{
        0.17543859649122806`, 2.456140350877193}}}]}, {}}, {}}, {{}, 
     GraphicsComplexBox[{{0., 2.6315789473684212`}, {0.819672131147541, 
      2.6315789473684212`}, {0., 0.}, {0.819672131147541, 0.}}, {{{}, 
        {RGBColor[0, 1, 1], EdgeForm[None], 
         GraphicsGroupBox[PolygonBox[{{1, 3, 4, 2}}]]}, {}, {}}, {{}, {}, 
        {Hue[0.67, 0.6, 0.6], Opacity[0], LineBox[{1, 2}]}}}], {}}, {{}, 
     GraphicsComplexBox[{{0., 2.6315789473684212`}, {2.6315789473684212`, 
      0.}, {0., 0.}}, {{{}, 
        {RGBColor[0.7, 0.4, 0.7], EdgeForm[None], 
         GraphicsGroupBox[PolygonBox[{{1, 3, 2}}]]}, {}, {}}, {{}, {}, 
        {Hue[0.67, 0.6, 0.6], Opacity[0], LineBox[{1, 2}]}}}], {}}, {{}, {
      {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         StyleBox["\[FilledVerySmallSquare]",
          StripOnInput->False,
          FontSize->24], {0., 0.}], {{{0.1694915254237288, 
        2.4620874219446924`}}, {{0.3225806451612903, 2.3089983022071308`}}, {{
        0.4504504504504504, 2.181128496917971}}, {{0.4587155963302752, 
        2.172863351038146}}, {{0.7575757575757576, 1.8740031897926637`}}, {{
        0.78125, 1.8503289473684212`}}, {{0.8695652173913044, 
        1.7620137299771168`}}, {{1.0204081632653061`, 1.611170784103115}}, {{
        1.1494252873563218`, 1.4821536600120995`}}, {{1.5151515151515151`, 
        1.116427432216906}}, {{1.6129032258064517`, 1.0186757215619695`}}, {{
        2.127659574468085, 0.5039193729003362}}}]}, {}}, {}}, {{}, {
      {RGBColor[0, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         StyleBox["\[FivePointedStar]",
          StripOnInput->False,
          FontSize->12], {0., 0.}], {{{2.6315789473684212`, 0.}}, {{
        1.6949152542372883`, 0.936663693131133}}, {{0.9433962264150942, 
        1.688182720953327}}, {{0.8620689655172414, 1.7695099818511797`}}}]}, 
      {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         StyleBox["\[FilledSmallCircle]",
          StripOnInput->False,
          FontSize->14], {0., 0.}], {{{0.819672131147541, 
        2.1213748657357683`}}, {{0.819672131147541, 2.2982456140350878`}}, {{
        0.819672131147541, 2.4620874219446924`}}}]}, 
      {RGBColor[0, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         StyleBox["\[FivePointedStar]",
          StripOnInput->False,
          FontSize->12], {0., 0.}], {{{0.5102040816326531, 
        2.1213748657357683`}}, {{0.3333333333333333, 2.2982456140350878`}}, {{
        0.17543859649122806`, 2.456140350877193}}}]}, {}}, {}}},
   AspectRatio->NCache[-1 + GoldenRatio, 0.6180339887498949],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Epilog->{
     InsetBox[
      FormBox[
       StyleBox[
       "\"Isotropic\\nLiquid\"", FontSize -> 14, StripOnInput -> False], 
       TraditionalForm], 
      Scaled[{0.72, 0.65}]], 
     InsetBox[
      FormBox[
       StyleBox["\"Chiral\\nLiquid\"", FontSize -> 14, StripOnInput -> False],
        TraditionalForm], 
      Scaled[{0.24, 0.86}]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"(Chiral)\\nNematic\"", FontSize -> 14, StripOnInput -> False], 
       TraditionalForm], 
      Scaled[{0.24, 0.4}]]},
   Frame->True,
   FrameLabel->{{None, None}, {None, None}},
   FrameStyle->Directive[
     GrayLevel[0], 13],
   FrameTicks->{{{{0, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(C\\), \\(1\\)]\\)\"", TraditionalForm]}, {
       0.936663693131133, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(C\\), \\(\[Infinity]\\)]\\)\"", 
         TraditionalForm]}, {1.688182720953327, ""}, {1.658182720953327, 
        FormBox["\"D2\"", TraditionalForm], 0}, {1.7695099818511797`, ""}, {
       1.7995099818511797`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(\[Infinity]\\)]\\)\"", 
         TraditionalForm], 0}, {2.1213748657357683`, 
        FormBox["\"T\"", TraditionalForm]}, {2.2982456140350878`, 
        FormBox["\"O\"", TraditionalForm]}, {2.456140350877193, 
        FormBox["\"I \"", TraditionalForm]}, {2.6315789473684212`, 
        FormBox["\"SO(3)\"", TraditionalForm]}}, {{0.5039193729003362, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(C\\), \\(1  \
v\\)]\\)=\\!\\(\\*SubscriptBox[\\(C\\), \\(1  h\\)]\\)\"", 
         TraditionalForm]}, {1.0186757215619695`, ""}, {1.0086757215619695`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(C\\), \\(\[Infinity]v\\)]\\)\"", 
         TraditionalForm], 0}, {1.116427432216906, ""}, {1.126427432216906, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(S\\), \
\\(2\\)]\\)=\\!\\(\\*SubscriptBox[\\(C\\), \\(i\\)]\\)\"", TraditionalForm], 
        0}, {1.4821536600120995`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(C\\), \\(2  h\\)]\\)\"", 
         TraditionalForm]}, {1.611170784103115, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(C\\), \
\\(\[Infinity]h\\)]\\)=\\!\\(\\*SubscriptBox[\\(S\\), \
\\(\[Infinity]\\)]\\)\"", TraditionalForm]}, {1.7220137299771168`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(2  h\\)]\\)\"", TraditionalForm],
         0}, {1.7620137299771168`, ""}, {1.8303289473684212`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(2  d\\)]\\)\"", TraditionalForm],
         0}, {1.8503289473684212`, ""}, {1.8740031897926637`, ""}, {
       1.9340031897926637`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(D\\), \
\\(\[Infinity]h\\)]\\)=\\!\\(\\*SubscriptBox[\\(D\\), \
\\(\[Infinity]d\\)]\\)\"", TraditionalForm], 0}, {Null, ""}, {
       2.172863351038146, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \
\\(d\\)]\\),\\!\\(\\*SubscriptBox[\\(T\\), \\(h\\)]\\)\"", 
         TraditionalForm]}, {2.181128496917971, ""}, {2.3089983022071308`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(O\\), \\(h\\)]\\)\"", TraditionalForm]}, {
       2.4620874219446924`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(h\\)]\\)\"", TraditionalForm]}, {
       2.6315789473684212`, 
        FormBox["\"O(3)\"", TraditionalForm]}}}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->500,
   Method->{},
   PlotRange->{{0, 2.7315789473684213`}, {0, 2.6315789473684212`}},
   PlotRangePadding->{{0, 0}, {0, 0}},
   Prolog->{
     RGBColor[0.8090169943749475, 0.8090169943749475, 0.8090169943749475], 
     RectangleBox[
      Scaled[{0, 0}], 
      Scaled[{1, 1}]]},
   Ticks->{Automatic, Automatic}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.659298410759905*^9, 3.6592984197995043`*^9}, {
   3.659380867010385*^9, 3.659380923397707*^9}, 3.659380992177032*^9, 
   3.659631466947184*^9, {3.659631507293027*^9, 3.659631560822093*^9}, {
   3.659631623339645*^9, 3.6596317678919973`*^9}, {3.659631818330598*^9, 
   3.6596320067442513`*^9}, {3.659633489864273*^9, 3.659633506569255*^9}, {
   3.659633565012574*^9, 3.659633575740561*^9}, {3.659633607396689*^9, 
   3.659633732215632*^9}, 3.659633788721982*^9, 3.664174661566391*^9, 
   3.664174724765683*^9, 3.664174797239399*^9, 3.66417491915666*^9, {
   3.6641749771658297`*^9, 3.6641749897648373`*^9}, 3.664175194773188*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\</Users/Ke/Desktop/phase_diagram.pdf\>\"", ",", "PD"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.657191865595111*^9, 3.657191892643515*^9}, {
   3.657191937522029*^9, 3.657191971283009*^9}, 3.65719204287381*^9}],

Cell[BoxData[
 FormBox["\<\"/Users/Ke/Desktop/phase_diagram.pdf\"\>", 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.657192043978211*^9, 3.6571920952091618`*^9, 
  3.657193445064118*^9, 3.657194122848308*^9, 3.658939151217602*^9, 
  3.6589393167331123`*^9, 3.658939359746375*^9, 3.658939391011149*^9, 
  3.6589398645413933`*^9, 3.658939982754533*^9, 3.658940120449376*^9, 
  3.658940654107061*^9, 3.658943112646158*^9, 3.658943256745491*^9, 
  3.659296315646721*^9, 3.659298433990829*^9, 3.659381041992116*^9, 
  3.65963201816322*^9, 3.6596337949640093`*^9, 3.664175217893446*^9}]
}, Open  ]]
},
WindowSize->{640, 774},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 9, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 151, 3, 28, "Input"],
Cell[712, 25, 11967, 310, 624, "Input"],
Cell[CellGroupData[{
Cell[12704, 339, 28079, 697, 1100, "Input"],
Cell[40786, 1038, 2209, 44, 244, "Output"],
Cell[42998, 1084, 8564, 173, 292, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51599, 1262, 265, 5, 28, "Input"],
Cell[51867, 1269, 586, 9, 28, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
